/*
** ###################################################################
**     This code is generated by the Device Initialization Tool.
**     It is overwritten during code generation.
**     USER MODIFICATION ARE PRESERVED ONLY INSIDE INTERRUPT SERVICE ROUTINES
**     OR EXPLICITLY MARKED SECTIONS
**
**     Project   : ts_controller
**     Processor : MC9S08QE8CPB
**     Version   : Bean 01.254, Driver 01.04, CPU db: 2.87.130
**     Datasheet : MC9S08QE8 Rev. 2 6/2006
**     Date/Time : 11/12/2008, 4:21 PM
**     Abstract  :
**         This module contains device initialization code 
**         for selected on-chip peripherals.
**     Contents  :
**         Function "MCU_init" initializes selected peripherals
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2008
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################
*/

/* MODULE MCUinit */

#include <MC9S08QE8.h>                 /* I/O map for MC9S08QE8CPB */
#include "MCUinit.h"

/* User declarations and definitions */
                                                  
#include "comm.h"
#include "control_constants.h"
 volatile unsigned char ReceivedByte; 
 byte TX_array_size = sizeof(xy_data_toTX); 
/*   Code, declarations and definitions here will be preserved during code generation */
/* End of user declarations and definitions */


/*
** ===================================================================
**     Method      :  MCU_init (bean MC9S08QE8_16)
**
**     Description :
**         Device initialization code for selected peripherals.
** ===================================================================
*/
void MCU_init(void)
{
  /* ### MC9S08QE8_16 "Cpu" init code ... */
  /*  PE initialization code after reset */
  /* Common initialization of the write once registers */
  /* SOPT1: COPE=1,COPT=1,STOPE=1,BKGDPE=1,RSTPE=1 */
  SOPT1 = 0xF3;                                      
  /* SPMSC1: LVDF=0,LVDACK=0,LVDIE=0,LVDRE=1,LVDSE=1,LVDE=1,BGBE=0 */
  SPMSC1 = 0x1C;                                      
  /* SPMSC2: PDF=0,PPDF=0,PPDACK=0,PDC=0,PPDC=0 */
  SPMSC2 = 0x00;                                      
  /* SPMSC3: LVDV=0,LVWV=0 */
  SPMSC3 &= (unsigned char)~0x30;                     
  /*  System clock initialization */
  ICSTRM = *(unsigned char*far)0xFFAF; /* Initialize ICSTRM register from a non volatile memory */
  ICSSC = *(unsigned char*far)0xFFAE;  /* Initialize ICSSC register from a non volatile memory */
  /* ICSC1: CLKS=0,RDIV=0,IREFS=1,IRCLKEN=0,IREFSTEN=0 */
  ICSC1 = 0x04;                        /* Initialization of the ICS control register 1 */
  /* ICSC2: BDIV=0,RANGE=0,HGO=0,LP=0,EREFS=0,ERCLKEN=0,EREFSTEN=0 */
  ICSC2 = 0x00;                        /* Initialization of the ICS control register 2 */
  /* SOPT2: COPCLKS=0,IICPS=0,ACIC=0 */
  SOPT2 = 0x00;                                      
  /* Common initialization of the CPU registers */
  /* PTASE: PTASE4=1,PTASE3=1,PTASE2=1,PTASE1=1,PTASE0=1 */
  PTASE |= (unsigned char)0x1F;                               
  /* PTBSE: PTBSE7=1,PTBSE6=1,PTBSE5=1,PTBSE4=1,PTBSE3=1,PTBSE2=1,PTBSE1=1,PTBSE0=1 */
  PTBSE = 0xFF;                                      
  /* PTADS: PTADS5=0,PTADS4=0,PTADS3=0,PTADS2=0,PTADS1=0,PTADS0=0 */
  PTADS = 0x00;                                      
  /* PTBDS: PTBDS7=0,PTBDS6=0,PTBDS5=1,PTBDS4=1,PTBDS3=1,PTBDS2=1,PTBDS1=0,PTBDS0=0 */
  PTBDS = 0x3C;                                      
  /* ### Init_SCI init code */
  /* SCIC2: TIE=0,TCIE=0,RIE=0,ILIE=0,TE=0,RE=0,RWU=0,SBK=0 */
  SCIC2 = 0x00;                        /* Disable the SCI module */
  (void)(SCIS1 == 0);                  /* Dummy read of the SCIS1 registr to clear flags */
  (void)(SCID == 0);                   /* Dummy read of the SCID registr to clear flags */
  /* SCIS2: BRK13=0,RAF=0 */
  SCIS2 = 0x00;                                      
  SCIC1 = 0x00;                                      
  /* SCIC3: R8=0,T8=0,TXDIR=0,TXINV=0,ORIE=0,NEIE=0,FEIE=0,PEIE=0 */
  SCIC3 = 0x00;                                      
#ifdef SERIAL_RX_SUPPORTED         // Enable the RX IRQ
  /* SCIC2: TIE=0,TCIE=0,RIE=1,ILIE=0,TE=1,RE=1,RWU=0,SBK=0 */
  SCIC2 = 0x2C;                                      
  /* SCIBDH: SBR12=0,SBR11=0,SBR10=0,SBR9=0,SBR8=0 */
  SCIBDH = 0x40;                       /* BR = 0x34: 9600 baud default */                     
  /* SCIBDL: SBR7=0,SBR6=0,SBR5=1,SBR4=1,SBR3=0,SBR2=1,SBR1=0,SBR0=0 */
  SCIBDL = 0x34;                                      
  /* SCIC1: LOOPS=0,SCISWAI=0,RSRC=0,M=0,WAKE=0,ILT=0,PE=0,PT=0 */
#else
  /* SCIC2: TIE=0,TCIE=0,RIE=0,ILIE=0,TE=1,RE=1,RWU=0,SBK=0 */
  SCIC2 = 0x0C;                                      
  /* SCIBDH: SBR12=0,SBR11=0,SBR10=0,SBR9=0,SBR8=0 */
  SCIBDH = 0x00;                       /* BR = 0x34: 9600 baud default */                     
  /* SCIBDL: SBR7=0,SBR6=0,SBR5=1,SBR4=1,SBR3=0,SBR2=1,SBR1=0,SBR0=0 */
  SCIBDL = 0x34;                                      
  /* SCIC1: LOOPS=0,SCISWAI=0,RSRC=0,M=0,WAKE=0,ILT=0,PE=0,PT=0 */
#endif
  /* ### Init_ADC init code */
  /* APCTL1: ADPC7=0,ADPC6=0,ADPC5=0,ADPC4=0,ADPC3=0,ADPC2=0,ADPC1=0,ADPC0=0 */
  APCTL1 = 0x00;                                      
  /* ADCCFG: ADLPC=0,ADIV1=0,ADIV0=0,ADLSMP=0,MODE1=1,MODE0=0,ADICLK1=0,ADICLK0=0 */
  ADCCFG = 0x08;                                      
  /* ADCSC2: ADACT=0,ADTRG=0,ACFE=0,ACFGT=0 */
  ADCSC2 = 0x00;                                      
  /* ADCCV: ADCV9=0,ADCV8=0,ADCV7=0,ADCV6=0,ADCV5=0,ADCV4=0,ADCV3=0,ADCV2=0,ADCV1=0,ADCV0=0 */
  ADCCV = 0x00;                                      
  /* ADCSC1: COCO=0,AIEN=0,ADCO=1,ADCH4=1,ADCH3=1,ADCH2=1,ADCH1=1,ADCH0=1 */
  ADCSC1 = 0x3F;                                      
  /* ### Init_GPIO init code */
  /* PTBD: PTBD7=1,PTBD6=1,PTBD5=0,PTBD4=0,PTBD3=0,PTBD2=0 */
  PTBD = (PTBD & (unsigned char)~0x3C) | (unsigned char)0xC0;
  /* PTBPE: PTBPE5=0,PTBPE3=1 */
  PTBPE = (PTBPE & (unsigned char)~0x20) | (unsigned char)0x08;
  /* PTBDD: PTBDD7=1,PTBDD6=1,PTBDD5=0,PTBDD4=0,PTBDD3=0,PTBDD2=0 */
  PTBDD = (PTBDD & (unsigned char)~0x3C) | (unsigned char)0xC0;
  /* ### Init_COP init code */
  SRS = 0xFF;                          /* Clear WatchDog counter */
  /* ### Init_FLASH init code */
  /* FSTAT: FCBEF=0,FCCF=0,FPVIOL=1,FACCERR=1,FBLANK=0 */
  FSTAT = 0x30;                        /* Clear error flags */
  /* FCDIV: DIVLD=0,PRDIV8=0,DIV5=1,DIV4=0,DIV3=1,DIV2=1,DIV1=0,DIV0=0 */
  FCDIV = 0x2C;                        /* Set clock divider */
  /* ### Init_TPM init code */
  /* TPMSC: TOF=0,TOIE=0,CPWMS=0,CLKSB=0,CLKSA=0,PS2=0,PS1=0,PS0=0 */
  TPM1SC = 0x00;                        /* Stop and reset counter */
  TPM1MOD = 0x00;                       /* Period value setting */
  (void)(TPM1SC == 0);                  /* Overflow int. flag clearing (first part) */
  /* TPMSC: TOF=0,TOIE=0,CPWMS=0,CLKSB=0,CLKSA=1,PS2=1,PS1=1,PS0=0 */
  TPM1SC = 0x0E;                        /* Int. flag clearing (2nd part) and timer control register setting */
  /* ### Init_KBI init code */
  /* KBISC: KBIE=0 */
  KBISC &= (unsigned char)~0x02;                     
  /* KBIES: KBEDG7=0,KBEDG6=0,KBEDG5=0,KBEDG4=0,KBEDG3=0,KBEDG2=0,KBEDG1=0,KBEDG0=0 */
  KBIES = 0x00;                                      
  /* KBISC: KBIMOD=1 */
  KBISC |= (unsigned char)0x01;                               
  /* KBIPE: KBIPE7=0,KBIPE6=0,KBIPE5=0,KBIPE4=0,KBIPE3=0,KBIPE2=0,KBIPE1=0,KBIPE0=0 */
  KBIPE = 0x00;                                      
  /* KBISC: KBACK=1 */
  KBISC |= (unsigned char)0x04;                               
  /* KBISC: KBIE=1 */
  KBISC |= (unsigned char)0x02;                               
  /* ### */
  asm CLI;                             /* Enable interrupts */
} /*MCU_init*/


/*
** ===================================================================
**     Interrupt handler : isrVadc
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
__interrupt void isrVadc(void)
{
  /* Write your interrupt code here ... */

}
/* end of isrVadc */


/*
** ===================================================================
**     Interrupt handler : isr_XP_KBI
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
__interrupt void isr_XP_KBI(void)
{
   KBISC_KBIE   = 0;               //Disable the KBI module 
   PTBPE_PTBPE3 = 0;               //Disable pull-up on XP pin
   KBIPE_KBIPE7 = 0;               //Change XP into a GPIO pin
   KBISC_KBACK  = 1;               //Clear the interrupt flag
}
/* end of isr_XP_KBI */


/*
** ===================================================================
**     Interrupt handler : UART_TX_ISR
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
__interrupt void UART_TX_ISR(void)
{
  /* Write your interrupt code here ... */
    unsigned char Temp;

    Temp = SCIS1;                         // Acknowledge TX buffer empty Flag
    if (byte_to_TX != 0){
      SCID = xy_data_toTX[byte_to_TX];    // Transmit the next byte
      byte_to_TX++;
      if (byte_to_TX >= TX_array_size) {  // All bytes have been sent
        SCIC2_TIE = 0;                    // Turn off the TX Interrupt
        byte_to_TX = 0;                   // Won't enter stop mode until this is zero
      } 
    }else {
        SCIC2_TIE = 0;                    // Should not have gotten here, make sure interrupt routine is off
    }
    
       
    
}
/* end of UART_TX_ISR */


/*
** ===================================================================
**     Interrupt handler : UART_RX_ISR
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
**
**     The data from the SCI is received here but processed in the Process_RX_Data
**     function found in comm.c.  The SCI reciever can wake the uC from STOP3 mode.
**     But the clocks are also stopped in this mode.  Consequently, the first byte
**     of data is often corrupted.  As a result, this protocol requires that the
**     'command' byte be sent twice.  This routine will ignore the first byte and 
**     process the second.  If the "i" command is being sent, the main control loop
**     will prevent the uC from going to Stop mode until all of the bytes have been 
**     received.  This prevents having to send each byte twice.
** ===================================================================
*/
__interrupt void UART_RX_ISR(void)
{
    unsigned char Temp;
    unsigned char test;

    if(SCIBDH_RXEDGIE){          // Entered Interrupt while in Stop mode
      SCIBDH_RXEDGIE = 0;       // Disable Wakeup Interrupt
      SCIS2_RXEDGIF = 1;        // Reset the wakeup flag
      while(!SCIS1_RDRF);       // Wait until the buffer full flag is set.  This also acknowledges the flag.
      Temp = SCID;              // The first read data is unreliable because the SCI clocks were restarting
                                // while the first char was being transmitted.
      stay_awake_for_RX = 1;    // Do not go to STOP until the entire message is read.
    }
      
    while(!SCIS1_RDRF);         // while loop needed for when woken from STOP
      
    if(temp_buffer[0] == 0){ 
      buffer_index = 0;
      temp_buffer[0] = SCID;
    } else {
      buffer_index++;
      temp_buffer[buffer_index] = SCID;
    }    
    
    test = temp_buffer[0] + 1;
    while (SCIS1_TDRE == 0);
    SCID = test;
    

}
/* end of UART_RX_ISR */


/*
** ===================================================================
**     Interrupt handler : isrVscierr
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
__interrupt void isrVscierr(void)
{
  /* Write your interrupt code here ... */
  byte tempscier;
  tempscier = SCIS1;
  tempscier = SCID;
  
}
/* end of isrVscierr */


/*
** ===================================================================
**     Interrupt handler : isrVtpmovf
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
__interrupt void isrVtpmovf(void)
{
/* Write your interrupt code here ... */
  byte tempovf;
  
  tempovf =  TPM1SC;
  TPM1SC_TOF = 0;

}
/* end of isrVtpmovf */



/* Initialization of the CPU registers in FLASH */

/* NVPROT: FPS=0x7F,FPDIS=1 */
const unsigned char NVPROT_INIT @0x0000FFBD = 0xFF;

/* NVOPT: KEYEN=0,FNORED=1,SEC01=1,SEC00=0 */
const unsigned char NVOPT_INIT @0x0000FFBF = 0x7E;



extern near void _Startup(void);

/* Interrupt vector table */
#ifndef UNASSIGNED_ISR
  #define UNASSIGNED_ISR 0xFFFF        /* unassigned interrupt service routine */
#endif

void (* near const _vect[])() @0xFFD0 = { /* Interrupt vector table */
         UNASSIGNED_ISR,               /* Int.no. 23 Vrti (at FFD0)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 22 Reserved2 (at FFD2)             Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 21 Reserved3 (at FFD4)             Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 20 Vacmp (at FFD6)                 Unassigned */
         isrVadc,                      /* Int.no. 19 Vadc (at FFD8)                  Used */
         isr_XP_KBI,                   /* Int.no. 18 Vkeyboard (at FFDA)             Used */
         UNASSIGNED_ISR,               /* Int.no. 17 Viic (at FFDC)                  Unassigned */
         UART_TX_ISR,                  /* Int.no. 16 Vscitx (at FFDE)                Used */
         UART_RX_ISR,                  /* Int.no. 15 Vscirx (at FFE0)                Used */
         isrVscierr,                   /* Int.no. 14 Vscierr (at FFE2)               Used */
         UNASSIGNED_ISR,               /* Int.no. 13 Vspi (at FFE4)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 12 Vmtim (at FFE6)                 Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 11 Reserved13 (at FFE8)            Unassigned */
         UNASSIGNED_ISR,               /* Int.no. 10 Reserved14 (at FFEA)            Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  9 Reserved15 (at FFEC)            Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  8 Reserved16 (at FFEE)            Unassigned */
         isrVtpmovf,                   /* Int.no.  7 Vtpmovf (at FFF0)               Used */
         UNASSIGNED_ISR,               /* Int.no.  6 Vtpmch1 (at FFF2)               Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  5 Vtpmch0 (at FFF4)               Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  4 Reserved20 (at FFF6)            Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  3 Vlvd (at FFF8)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  2 Virq (at FFFA)                  Unassigned */
         UNASSIGNED_ISR,               /* Int.no.  1 Vswi (at FFFC)                  Unassigned */
         _Startup                      /* Int.no.  0 Vreset (at FFFE)                Reset vector */
};






/*
** ===================================================================
**     Interrupt handler : isrViic
**
**     Description :
**         User interrupt service routine. 
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
__interrupt void isrViic(void)
{
     /* Write your interrupt code here ... */
 
}
/* end of isrViic */

/* END MCUinit */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 3.03 [04.07]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
